(******************************************************************************
 * Copyright (c) 2012-2013, Toyama&Aoto Laboratory, Tohoku University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the 
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************)
(******************************************************************************
 * file: rwtools/commands/tpdb.lex
 * description: (incomplete) lexer for TPDB (Termination Problem Data Base) format
 * author: AOTO Takahito
 * 
 ******************************************************************************)

structure Tokens = Tokens;
type pos = int;
type svalue = Tokens.svalue;
type ('a,'b) token = ('a,'b) Tokens.token;
type lexresult = (svalue, pos) token;

open Tokens
val pos = ref 1;
val pr = fn s : string => TextIO.output(TextIO.stdErr, s)
val eof = fn () => (pos:=1; Tokens.EOF(!pos,!pos));
val text = ref (nil: string list)
val Add = fn s => (text := s::(!text))
%%
%header (functor TpdbLexFun (structure Tokens: Tpdb_TOKENS));
%s STRING;
idstr = [\]\[!#$%&'\*\+./:;<=>?@\\^_`{}~a-zA-Z0-9\-];
%%
<INITIAL>\n	     => (pos:=(!pos)+1; lex()  (* Ԥ *));
<INITIAL>[\ \013
\t]+     => (lex() (* ϥå *));
<INITIAL>"->"  	       => (Tokens.ARROW(!pos,!pos));
<INITIAL>"="  	       => (Tokens.EQUAL(!pos,!pos));
<INITIAL>"=="  	       => (Tokens.DEQS(!pos,!pos));
<INITIAL>"|"           => (Tokens.BAR(!pos,!pos));
<INITIAL>"->="         => (Tokens.ARROWEQ(!pos,!pos));
<INITIAL>"("    	     => (Tokens.LPAREN(!pos,!pos));
<INITIAL>","    	     => (Tokens.COMMA(!pos,!pos));
<INITIAL>"\""	     => (text := nil; Add yytext;
                         YYBEGIN STRING; continue());
<INITIAL>")"    	     => (Tokens.RPAREN(!pos,!pos));
<INITIAL>VAR          => (Tokens.VAR(!pos,!pos));
<INITIAL>SIG          => (Tokens.SIG(!pos,!pos));
<INITIAL>RULES        => (Tokens.RULES(!pos,!pos));
<INITIAL>CONTEXTSENSITIVE => (Tokens.CONTEXTSENSITIVE(!pos,!pos));
<INITIAL>EQUATIONS => (Tokens.EQUATIONS(!pos,!pos));
<INITIAL>INNERMOST => (Tokens.INNERMOST(!pos,!pos));
<INITIAL>OUTERMOST => (Tokens.OUTERMOST(!pos,!pos));
<INITIAL>STRATEGY => (Tokens.STRATEGY(!pos,!pos));
<INITIAL>THEORY    => (Tokens.THEORY(!pos,!pos));
<INITIAL>PROBLEM    => (Tokens.PROBLEM(!pos,!pos));
<INITIAL>CONDITIONTYPE  => (Tokens.CONDITIONTYPE(!pos,!pos));
<INITIAL>{idstr}+ => (Tokens.ID(yytext,!pos,!pos));
<INITIAL>. => (print ("lex omitted [" ^ yytext ^ "]\n");continue ());
<STRING>"\""	=> (Add yytext; YYBEGIN INITIAL; 
                    Tokens.ID(String.concat (List.rev (!text)),!pos,!pos));
<STRING>[^"\n]+ => (Add yytext; continue());
<STRING>\n	     => (Add yytext; pos:=(!pos)+1; continue());
