(* file: assoc_list.sml *)
(* description: functions for association list *)
(* author: Masaomi Yamaguchi, Takahito Aoto *)

signature NUE_ASSOC_LIST  =
sig
    val find: ''a -> (''a * 'b) list -> 'b option
    val add: (''a * ''b) -> (''a * ''b) list -> (''a * ''b) list option
    val union:  (''a * ''b) list *  (''a * ''b) list ->  (''a * ''b) list option
    val largeUnion: (''a * ''b) list list -> (''a * ''b) list option
end

structure NueAssocList : NUE_ASSOC_LIST=
struct 

fun find x [] = NONE
  | find x ((k,v)::ys) = if x = k then SOME v else find x ys

fun add (k,v) ys = case find k ys of
		       SOME w => if v = w then SOME ys
				 else NONE
		     | NONE => SOME ((k,v)::ys)

local exception none
in
fun union (xs,ys) = SOME (foldr (fn (x,ys') => case add x ys' of
						      NONE => raise none
						    | SOME list => list 
				) ys xs) handle none => NONE
							    
fun largeUnion xs = SOME (foldr (fn (a,b) => case union (a,b) of
					   NONE => raise none
					 | SOME list => list
			  ) [] xs) handle none => NONE
end				    
end
