(* file: eun.sml *)
(* description: Efficiently check UN for shallow TRS with CP *)
(* author: Masaomi Yamaguchi *)
structure NueEUN: NUE_UNIQUENESS_OF_NORMAL_FORMS =
struct 

local 
    structure AL = NueAssocList
    structure CP = NueCP
    structure CompE = NueCompE
    structure FlatTrs = NueFlatTrs
    structure Flatting = NueFlatting
    structure Hat = NueHat
    structure L = List
    structure LU = NueListUtil
    structure Measure = NueMeasure
    structure OrderRewrite = NueOrderRewrite
    structure Rewrite = NueRewrite
    structure T = NueTerm
    structure Trs = NueTrs
    open PrintUtil
in

(* CPNFを使って項中の定数を置き換える *)
fun replace CPnf chat t = CP.replace CPnf (chat t)

(* CWに反例が存在するか調べる *)
fun checkCW rs CPnf chat [] = NONE
  | checkCW rs CPnf chat ((s,t)::cpE) =
    let val (s',t') = (replace CPnf chat s, replace CPnf chat t)
 (*   in if s' <> t' andalso Rewrite.isNF rs s' andalso Rewrite.isNF_root rs t' *)
    in if s' <> t' andalso Rewrite.isNF rs s' andalso Rewrite.isNF rs t' (* bug fix 2019/03/14 *)
       then SOME (s',t')
       else checkCW rs CPnf chat cpE
    end
	
				       
fun checkUN_print_sub rs =
    (let
	(* フラット変換 *)
	val rs = (print ("Input:\n"^(Trs.prRules rs)^"\n");
		  Measure.pf "Make it flat:\n" (Trs.prRules) (fn () => Flatting.flatting rs))
	(* 関数記号一覧(アリティつき) *)
	val fs = FlatTrs.function_symbols_with_arity rs
	(* 定数の集合 *)			
	val C = FlatTrs.constant fs
	(* 完備化 *)
	val cpE = Measure.pf "Make it Complete (R^):\n" (Trs.prEqs) (fn () => CompE.comp rs)
	(* order rewrite用にcpEを変換 *)
	val cpTrs = CompE.compTrs cpE
	(* フラットな項の代表元を返す関数 *)
	val hat = Hat.hat (Hat.calc_sigma_c cpTrs)
	(* constant hat フラットな項中の定数を代表元に置き換える関数 *)
	val chat = Hat.chat (Hat.calc_sigma_c cpTrs)
	(* CPアルゴリズムを実行 *)
	val CPnfOP = Measure.pf "CPNF:\n" (CP.toStringOP) (fn () => CP.CPa rs cpE hat C)
	(* CPのあとCWを計算してUN性判定 *)
	fun main (CPnf,NONE) =
	    (print ("Now checking all the pairs in CW...\n\n");
	     Measure.p (fn () => checkCW rs CPnf chat cpE) "Time to check pairs: ")
	  | main  (CPnf,SOME (t1,t2)) = SOME (t1,t2)
    in
	(* 実行結果出力 *)
	case main CPnfOP of
	    SOME (t1,t2) => (print ("The TRS doesn't have Uniqueness of Normal Forms.\n"
				    ^"Counter Example: \n"
				    ^ "     " ^ (T.toString t1) ^ "\n"
				    ^ "<->* " ^ (T.toString t2) ^ "\n\n");
			     print "proof:\n";
			     OrderRewrite.listepsToNF cpTrs t1;
			     print "\n";
			     OrderRewrite.listepsToNF cpTrs t2;
			     false)
	  | NONE => (print "The TRS has Uniqueness of Normal Forms.\n"; true)
			  
    end) handle CompE.Inconsistent =>
		(print "The TRS doesn't have Uniqueness of Normal Forms because it is inconsistent.\n"; false)


fun checkUN_print rs =
    Measure.p (fn () => checkUN_print_sub rs) "Total Time: ";
(*    checkUN_print_sub rs *)


fun checkUN rs =
    (let val rs = Flatting.flatting rs
	 val fs = FlatTrs.function_symbols_with_arity rs		
	 val C = FlatTrs.constant fs		
	 val cpE = CompE.comp rs
	 val cpTrs = CompE.compTrs cpE
	 val hat = Hat.hat (Hat.calc_sigma_c cpTrs)
	 val chat = Hat.chat (Hat.calc_sigma_c cpTrs)
	 val CPnfOP = CP.CPa rs cpE hat C
	 fun main (CPnf,NONE) = checkCW rs CPnf chat cpE
	   | main  (CPnf,SOME (t1,t2)) = SOME (t1,t2)
     in
	 main CPnfOP
     end) handle CompE.Inconsistent => SOME (T.Var ("x",0),T.Var ("y",0))

	

end (* of local *)
end (* of struct *)
