(* file: hat.sml *)
(* description: calculate representative element (for flat term) *)
(* author: Masaomi Yamaguchi *)

signature NUE_HAT = 
sig
    type sigma_c = (NueFun.key * NueFun.key) list
    type hat = NueTerm.term -> NueTerm.term
    val rename: NueTerm.term -> NueTerm.term
    val calc_sigma_c: NueTrs.trs -> sigma_c
    val hat: sigma_c -> NueTerm.term -> NueTerm.term
    val chat: sigma_c -> NueTerm.term -> NueTerm.term
end

structure NueHat: NUE_HAT =
struct 

local 
    structure L = List
    structure LU = NueListUtil
    structure T = NueTerm
    structure S = NueSubst
    structure FlatTrs = NueFlatTrs
    structure OrderRewrite = NueOrderRewrite
    structure AL = NueAssocList
    structure Fun = NueFun
in
type sigma_c = (Fun.key * Fun.key) list
type hat = T.term -> T.term
			    
(* 変数の名前変えを行い，変数名を正規化 *)
fun rename t = let val vars = T.vars t
		   val sigma = L.mapi (fn (n,x) => (x,T.Var ("x",n))) vars
	       in
		   S.apply sigma t
	       end

(* 代表元を計算するためのモジュールを計算 *)
fun calc_sigma_c rs =
    	 let val fs = FlatTrs.function_symbols_with_arity rs
	     val C = FlatTrs.constant fs
	 in map (fn (T.Fun (c,[])) => let val (T.Fun (c',[])) = OrderRewrite.linf rs (T.Fun(c,[]))
			 in (c,c')
			 end
		) C
	 end

fun apply sigma_c (T.Var x) = T.Var x
  | apply sigma_c (T.Fun (c,[])) = (case AL.find c sigma_c of NONE => T.Fun (c,[])
							  | SOME c' => T.Fun (c',[]))
  | apply sigma_c (T.Fun (f,ts)) = T.Fun (f,map (fn t => apply sigma_c t) ts)

(* 代表元を計算する *)
fun hat sigma_c t = apply sigma_c (rename t)

(* 定数を代表元にを置き換える *)	  
fun chat sigma_c t = apply sigma_c t

end (* of local *)
end (* of struct *)
