(* file: measure.sml *)
(* description: measure the time *)
(* author: Masaomi Yamaguchi *)

signature NUE_MEASURE = 
sig
    val m: (unit -> 'a) -> 'a * string
    val p: (unit -> 'a) -> string -> 'a
    val pf: string -> ('a -> string) -> (unit -> 'a) -> 'a	   
end

structure NueMeasure: NUE_MEASURE =
struct 

local 
    structure L = List
    open PrintUtil
in

fun m x = let val a = Timer.startRealTimer()
	    val b = x ()       
	in
	    (b,Time.toString (Timer.checkRealTimer(a)))
	end

(* prev xの計算にかかった時間 [s]\n\nを出力し，xの結果を返す *)
fun p x prev =
    let val (v,s) = m x
    in
	print (prev ^ s ^ " [s]\n\n");v
    end


(* prev xの計算結果をfで文字列にしたもの Time : xの計算にかかった時間 [s]\n\nを出力し，xの結果を返す *)
fun pf prev f x =
    let val (v,s) = m x
    in
	print (prev ^ f v ^ "Time: "^ s ^ " [s]\n\n");v
    end

end (* of local *)
end (* of struct *)
