(* file: path_order.sml *)
(* description: path orders for termination check *)
(* author: Takahito Aoto *)

signature NUE_PATH_ORDER = 
sig
    type prec = NueFun.key * NueFun.key -> bool
    val lpoGt: (NueTerm.term * NueTerm.term) -> bool
end

structure NuePathOrder: NUE_PATH_ORDER =
struct
local
    structure AL = NueAssocList
    structure L = List
    structure T = NueTerm
    structure Fun = NueFun
    structure Var = NueVar
    structure LU = NueListUtil
in

type prec = Fun.key * Fun.key -> bool

(* 辞書式拡張 *)
fun lex rel ([],[]) = false
  | lex rel (x::xs,y::ys) = if x = y then lex rel (xs,ys)
			    else rel (x,y)
  | lex rel _ = raise Fail "Error: lex compares lists having different length"

(* 辞書式経路順序による比較 *)
fun lpoGt (term1,term2) = 
    let fun gtX ((name_x,i_x),(name_y,i_y)) = if name_x = name_y then i_x > i_y
					      else name_x > name_y
	fun gtC (c1,c2) = c1 > c2
	fun gtF (f,g) = f > g
	fun gt (T.Var x, T.Var y) = gtX (x,y)
	  | gt (T.Var x,T.Fun _) = false
	  | gt (T.Fun (c,[]), T.Var x) = true
	  | gt (T.Fun (c,[]), T.Fun (c2,[])) = gtC (c,c2)
	  | gt (T.Fun (c,[]), T.Fun (f,ts)) = false 
	  | gt (T.Fun (f,ss), T.Var _) = true
	  | gt (T.Fun (f,ss), T.Fun (c,[])) = true 
	  | gt (s as (T.Fun (f,ss)), t as (T.Fun (g,ts))) = if f <> g then
								(geqforsome ss t) orelse (gtF (f,g) andalso (gtforall s ts))
							    else (geqforsome ss t) orelse ((lex gt (ss, ts)) andalso (gtforall s ts))
	and geq (s,t) = if s = t then true else gt (s,t)
	and gtforall s ts = L.all (fn tj => gt (s,tj)) ts
	and geqforsome ss t = L.exists (fn si => geq (si,t)) ss
    in gt (term1,term2)
    end

end (* of local *)
end (* of struct *)
