(******************************************************************************
 * Copyright (c) 2012-2015, Toyama&Aoto Laboratory, Tohoku University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the 
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************)
(******************************************************************************
 * file: rwtools/term_rewriting/var.sml
 * description: definition and utility functions for Variable Symbols
 * author: AOTO Takahito
 * 
 ******************************************************************************)

structure Var : sig
   include ORD_KEY2 (* { val ord_key, fun compare, fun equal, fun toString }*)
   val fromStringAndInt: string * int -> ord_key
   val fromString: string -> ord_key
   val increaseIndexBy: int -> ord_key -> ord_key
   val index: ord_key -> int
   val name: ord_key -> string
   val toProofTree: ord_key -> unit -> string
   val toStringWithoutQuestion: ord_key -> string
end = struct  
   type ord_key = Atom.atom * int
   fun compare ((x,i),(y,j)) = 
       case Atom.compare (x,y) 
	of GREATER => GREATER
	 | LESS => LESS
	 | EQUAL => Int.compare (i,j) 
   fun equal (x,y) = (compare (x,y)) = EQUAL
   fun toString (x,0) = "?" ^ (Atom.toString x) 
     | toString (x,i) = "?" ^ (Atom.toString x) ^ "_" ^ (Int.toString i) 
   fun fromStringAndInt (s,n) = (Atom.atom s,n)
   fun fromString s = fromStringAndInt (s,0)
   fun increaseIndexBy n (x,i) = (x,i+n)
   fun index (_,i) = i
   fun name (x,_) = Atom.toString x
   fun toProofTree (x,_) () = CertifyUtil.encloseProofLeafBy "var" (Atom.toString x)
   fun toStringWithoutQuestion (x,0) = (Atom.toString x) 
     | toStringWithoutQuestion (x,i) = (Atom.toString x) ^ "_" ^ (Int.toString i) 


end;

structure VarSet = RedBlackSetFn (Var) : ORD_SET
structure VarMap = RedBlackMapFn (Var) : ORD_MAP
structure VarPair = OrdKey2PairFn (structure A = Var structure B = Var) : ORD_KEY2
structure VarPairSet = RedBlackSetFn (VarPair) : ORD_SET
structure VarPairMap = RedBlackMapFn (VarPair) : ORD_MAP
