(******************************************************************************
 * Copyright (c) 2012-2015, Toyama&Aoto Laboratory, Tohoku University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the 
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************)
(******************************************************************************
 * file: rwtools/util/command_util.sml
 * description: utility for making commands applied to files
 * author: AOTO Takahito
 * 
 ******************************************************************************)

signature COMMAND_UTIL =  
sig
    val applyCmdToDirTree: (string * string -> unit) -> string * string -> unit
end

structure CommandUtil: COMMAND_UTIL =
struct
    fun applyCmdToDirTree cmd (path,target) =
	if (OS.FileSys.isDir target)
	then let val dir = OS.FileSys.openDir target
		 val path' = if path = "" then target else (path ^ "/" ^ target)
	     in (OS.FileSys.chDir target;
		 walkDirToApplyCmd cmd (path',dir);
		 OS.FileSys.closeDir dir;
		 OS.FileSys.chDir OS.Path.parentArc)
	     end
	else cmd (path, target)
    and walkDirToApplyCmd cmd (path,dir) = 
	let val item = OS.FileSys.readDir dir
	in case item of
               NONE => ()
             | SOME tgt => if tgt = "CVS" 
                           then walkDirToApplyCmd cmd (path,dir)
                           else (applyCmdToDirTree cmd (path,tgt);
                                 walkDirToApplyCmd cmd (path,dir))
	end

end

signature PROVER_RESULT =  
sig
    datatype prover_result = YES | NO | MAYBE
end

structure ProverResult: PROVER_RESULT =
struct
    datatype prover_result = YES | NO | MAYBE
end
