local 
    structure L = List
in

(* Assume 0 <= i,j <= len - 1, the index is 0 ... len*len - 1 *)
fun pairIndex len (i,j) = i*len + j

fun mkArray2 (len,init) = Array.array (len * len,init)

fun update2 len (ar, (i,j), new) =  Array.update (ar, pairIndex len (i,j), new)

fun sub2 len (ar, (i,j)) =  Array.sub (ar, pairIndex len (i,j))

exception ErrorNonElementFound 

fun getIndex _ [] _ = raise ErrorNonElementFound 
  | getIndex n (y::ys) x = if x = y then n
			   else getIndex (n+1) ys x

fun mkTransTable univ R = 
    let val len = L.length univ
	val table = mkArray2 (len, false)
	val getIdx = getIndex 0 univ
	val _ = L.app (fn (a,b) => update2 len (table, (getIdx a, getIdx b), true)) R
    in table
    end

fun transitiveClosure univ R = (univ, mkTransTable univ R)

fun check (univ, table) (a,b) =
    let val len = L.length univ
	val getIdx = getIndex 0 univ
    in sub2 len (table, (getIdx a, getIdx b))
    end

end
