(******************************************************************************
 * Copyright (c) 2012-2013, Toyama&Aoto Laboratory, Tohoku University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the 
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************)
(******************************************************************************
 * file: rwtools/util/time_util.sml
 * description: utility for reporting and limiting time
 * author: AOTO Takahito
 * 
 ******************************************************************************)

signature TIME_UTIL =  
sig
    val checkTime: Timer.cpu_timer -> IntInf.int
    val reportTime: IntInf.int * IntInf.int -> string
    val profile: (unit -> 'a) * string -> 'a
    val timeLimitRun: IntInf.int -> ('a -> 'b) -> 'a -> 'b
end;

structure TimeUtil: TIME_UTIL =
struct
   (***
    val timer = Timer.startCPUTimer ()
    val start = TimeUtil.checkTime timer 
    val result = main ()  
    val stop = TimeUtil.checkTime timer 
    val _ = print (" ("  ^ (TimeUtil.reportTime (start,stop)) ^ " msec.)\n")
    **)

    fun checkTime timer = 
	let val tm = (Timer.checkCPUTimer timer)
	in (Time.toMilliseconds (#usr tm)) + (Time.toMilliseconds (#sys tm))
	end

    fun reportTime (t1,t2) = Int.toString (LargeInt.toInt (t2 - t1))

     fun profile (main,str) =
	let
	    val timer = Timer.startCPUTimer ()
	    val _ = print ("[start " ^ str ^ " ")
 	    val start = checkTime timer 
	    val result = main ()
 	    val stop = checkTime timer 
	    val _ = print (" end " ^ str ^ "("  ^ (reportTime (start,stop)) ^ " msec.)]\n")
	in
	      result
	end

    (*** 
	 timeLimitRun n f x:
     $B;~4V$r(B n $BIC$K@)8B$7$F(B f x $B$r<B9T$9$k!%(B
     ***)

    fun timeLimitRun n f x =
	let
	    val timeout = Time.fromSeconds n
(* 	    val rt = Timer.startRealTimer() *)
(* 	    val ct = Timer.startCPUTimer() *)
	in
	    let 
		val res = TimeLimit.timeLimit timeout f x
(* 		val rtm = Timer.checkRealTimer rt; *)
(* 		val ctm = Timer.checkCPUTimer ct; *)
	    in 
		res
	    end
(* 	    handle TimeOut =>  *)
(* 		   let *)
(* 		       val rtm = Timer.checkRealTimer rt; *)
(* 		       val ctm = Timer.checkCPUTimer ct; *)
(* 		   in *)
(*  		      print "timeout(";  *)
(*   		      print (LargeInt.toString (Time.toSeconds rtm)); *)
(*   		      print " sec.)"; *)
(* 		      raise TimeOut *)
(* 		   end *)
	end
end

